-- MAIN TABLE 
WP_TABLE = {
	-- default CONFIG 
	config = {
		-- OLD CONFIG
		SINGLE_STEP_DELAY = 200, 
		MAX_STEP_DELAY = 1000, 
		CAP_REFILL = 200, 
		SUPPLIES_REFILL = 200, 
		MIN_MONSTER_STOP = 5, 
		MIN_MONSTER_RESUME = 2,
		-- NEW CONFIG
		HUNT_STYLE = 'SINGLE',
		REFILLAT = 'NPC',
		WAIT_MANA_AMMOUNT = 20,
		AUTO_LOOTER = 'false',
		WAIT_PING = 'false',
		SEE_DISTANCE = 6,		
		FORGE_TYPE = 'slivers',
		ANTI_GM = true,
		ALARM  = false,
		ENCHANT = true,
		STAMINA = true,
		IGNORE_BOX = false,
		WALK_MODE = 'click',
		-- BOX finish creatures %
		finish_box_creatures = true,
		finish_box_creatures_hp = 20,
		------------------
		-- STAMINA CHECKER / CHECK STAMINA at "checkRefill"
		check_stamina_on_refill = false,
		-- [ENGLISH] Stops on PZ if stamina is equal or less than 38:00 and continues at 42:00 
		-- [PT-BR] Para no PZ caso tenha 38:00 ou menos de stamina e continua com 42:00
		stop_hunting_if_stamina = 38,
		continue_hunting_if_stamina = 42,
		-- [ENGLISH Start hunting if X hours, stop hunting Y hours.
		-- [PT-BR] Vai pra hunt as X horas e sai dela X horas.
		check_hours_on_refill = false,
		start_hunting_if_hours = 1200, -- start hunt 12:00 PM
		stop_hunting_if_hours = 1500,  -- stop hunt 15:00 PM
		-- detect ITEM and pause walker if x item detected, if theres no item, resume walker
		pause_on_item = false,
		pause_on_itemid = {},
		pause_on_item_delay = 250,
		walk_to_item = true,
		SOUND = true,
	},
	-- default REFILL
	refill = {
		-- HP
		{name = "Supreme Health Potion", id = 23375, vocation = {"knight"}, amount = 0, type = 'potions'},
		{name = "Ultimate Health Potion", id = 7643, vocation = {"knight"}, amount = 0, type = 'potions'},
		{name = "Great Health Potion", id = 239, vocation = {"knight"}, amount = 0, type = 'potions'},
	--	{name = "Strong Health Potion", id = 236, vocation = {"knight","paladin"}, amount = 0, type = 'potions'},
		-- MANA
		{name = "Ultimate Mana Potion", id = 23373, vocation = {"sorcerer","druid"}, amount = 0, type = 'potions'},
		{name = "Great Mana Potion", id = 238, vocation = {"paladin","sorcerer","druid"}, amount = 0, type = 'potions'},
		{name = "Strong Mana Potion", id = 237, vocation = {"knight","paladin","sorcerer","druid"}, amount = 0, type = 'potions'},
		-- DISTANCE
		{name = "Diamond Arrow", id = 35901, vocation = {"paladin"}, amount = 0, type = 'distance'},
		{name = "Spectral Bolt", id = 35902, vocation = {"paladin"}, amount = 0, type = 'distance'},
		--{name = "Crystalline Arrow", id = 15793, vocation = {"paladin"}, amount = 0, type = 'distance'},
		-- SPIRIT
		{name = "Ultimate spirit Potion", id = 23374, vocation = {"paladin"}, amount = 0, type = 'potions'},
		{name = "Great Spirit Potion", id = 7642, vocation = {"paladin"}, amount = 0, type = 'potions'},
		-- RUNES
		{name = "Great Fireball Rune", id = 3191, vocation = {"knight","paladin","sorcerer","druid"}, amount = 0, type = 'runes'},
		{name = "Avalanche Rune", id = 3161, vocation = {"knight","paladin","sorcerer","druid"}, amount = 0, type = 'runes'},
		{name = "ThunderStorm Rune", id = 3202, vocation = {"knight","paladin","sorcerer","druid"}, amount = 0, type = 'runes'},
		{name = "Stone Shower Rune", id = 3175, vocation = {"paladin","sorcerer","druid"}, amount = 0, type = 'runes'},		
		{name = "Sudden Death Rune", id = 3155, vocation = {"paladin","sorcerer","druid"}, amount = 0, type = 'runes'},	
		{name = "Ultimate Healing Rune", id = 3160, vocation = {"knight","paladin","sorcerer","druid"}, amount = 0, type = 'runes'},
		-- ITEMS
		{name = "Might Ring", id = 3048, vocation = {"paladin","sorcerer","druid", "knight"}, amount = 0, type = 'rings'},	
		{name = "Stone Skin Amulet", id = 3081, vocation = {"knight","paladin","sorcerer","druid", "knight"}, amount = 0, type = 'amulets'},		
	},
	-- default WP table always EMPTY
	waypoints = {

	},
}

-- Enchantable items
mau_enchantable_items = {
	[29429] = "pendulet",
	[29428] = "sleep shawl",
	[31621] = "blister ring",
	[30401] = "theurgic amulet",
	[32636] = "ring of souls",
	[39182] = "alicorn ring",
	[39188] = "arboreal ring",
	[39185] = "arcanomancer sigil",
	[39179] = "charged spiritthorn ring",	
	[39235] = "turtle amulet",
}

--- ENGINE SPEED SETTINGS
engineSpeeds = {
	-- after_getNextIndex, mau_refill_step, openDoors
	[1] = {200, 50, 500},
	[2] = {100, 25, 300},
	[3] = {50, 25, 250},
	[4] = {25, 25, 100},
	[5] = {15, 15, 50},
	[6] = {5, 5, 10},
	[7] = {5, 5, 10},
	[8] = {5, 5, 10},
	[9] = {5, 5, 10},
	[10] = {5, 5, 10}
}
--- CAIT SPEED SETTINGS
caitSpeeds = {
	[1] = {500, 2500},
	[2] = {400, 2500},
	[3] = {400, 2000},
	[4] = {300, 1500},
	[5] = {200, 1000},
	[6] = {150, 800},
	[7] = {150, 500},
	[8] = {100, 200},
	[9] = {50, 100},
	[10] = {10, 10}
}

mau_engine_config = {
	mau_refill_step = 25, -- stepDelay player will have when going refill
	after_getNextIndex = 25, -- delay after calling getNextIndex
	box = 100, -- delay to wait after getting/leaving to box waypoint 
	stand = 100, -- delay to stay in stand
	openDoors = 10
}

-- Temple positions for rubinit instance system
mau_temple_positions = {
	oramond = {x = 33594, y = 31899, z = 6},
	roshamuul = {x = 33513, y = 32363, z = 6}
}

